-- Storage Module Reward Changes --
RewardChanges =
{
  { -- ListID
    {"R_MB_LOW"}, -- Mission Board Low
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  1,   1,     5}, -- 1, 1, 1
      {"SHIP_INV_TOKEN",  1,   1,     5}, -- 1, 1, 1
    }
  },
  {  
    {"R_MB_MED"}, -- Mission Board Med
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  2,   2,     5}, -- 1, 1, 1
      {"SHIP_INV_TOKEN",  2,   2,     5}, -- 1, 1, 1
    }
  },
  {  
    {"R_MB_HIGH"}, -- Mission Board High
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  3,   3,     5}, -- 1, 1, 1
      {"SHIP_INV_TOKEN",  3,   3,     5}, -- 1, 1, 1
    }
  },
  {  
    {"R_MB_MEGA"}, -- Mission Board Mega
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  4,   4,     5}, -- 1, 1, 1
      {"SHIP_INV_TOKEN",  4,   4,     5}, -- 1, 1, 1
    }
  },
  {  
    {"R_NEXUS_MEGA"}, -- Nexus Mission Mega
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  4,   4,    10}, -- 1, 1, 1
      {"SHIP_INV_TOKEN",  4,   4,    10}, -- 1, 1, 1
    }
  },
  {  
    {"R_PIRATEBOARD_A"}, -- Outlaw Bounty Master
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  2,   2,    60}, -- 1, 1, 60
      {"SHIP_INV_TOKEN",  2,   2,    60}, -- 1, 1, 60
      {"FREI_INV_TOKEN",  2,   2,    60}, -- 1, 1, 60
    }
  },
  {  
    {"CRASHCONT_S"}, -- Crash Freighter Small
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  1,   2,    15}, -- 1, 1, 8
    }
  },
  {  
    {"CRASHCONT_M"}, -- Crash Freighter Medium
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  2,   4,    15}, -- 1, 1, 8
    }
  },
  {  
    {"R_ABAND_TOKEN"}, -- Derelict Freighter Module End Terminal Option
    {   -- LootID,      Min, Max, Chance,   Original
      {"FREI_INV_TOKEN",  1,   3,   100}, -- 1, 1, 100
    }
  },
  {  
    {"FREIGHTER_SAVED"}, -- Saved Freighter
    {   -- LootID,      Min, Max, Chance,   Original
      {"FREI_INV_TOKEN",  1,   2,   100}, -- 1, 1, 100
    }
  },
  {  
    {"DE_RARE_CRATE"}, -- Buried Cache Crates
    {   -- LootID,      Min, Max, Chance,   Original
      {"WEAP_INV_TOKEN",  1,   2,    10}, -- 1, 1, 5
    }
  },
  {  
    {"SHUTTLE_C"}, -- C Class Shuttle Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   1,    20}, -- 1, 1, 20
    }
  },
  {  
    {"SHUTTLE_B"}, -- B Class Shuttle Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   2,    20}, -- 1, 1, 20
    }
  },
  {  
    {"SHUTTLE_A"}, -- A Class Shuttle Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  2,   3,    50}, -- 1, 2, 50
    }
  },
  {  
    {"SHUTTLE_S"}, -- S Class Shuttle Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  3,   4,   100}, -- 1, 3, 100
    }
  },
  {  
    {"DROPSHIP_C"}, -- C Class Hualer Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   1,    20}, -- 1, 1, 20
    }
  },
  {  
    {"DROPSHIP_B"}, -- B Class Hualer Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   2,    35}, -- 1, 1, 35
    }
  },
  {  
    {"DROPSHIP_A"}, -- A Class Hualer Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  2,   3,    65}, -- 1, 2, 65
    }
  },
  {  
    {"DROPSHIP_S"}, -- S Class Hualer Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  3,   4,   100}, -- 1, 3, 100
    }
  },
  {  
    {"FIGHTER_C"}, -- C Class Fighter Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   1,    20}, -- 1, 1, 20
    }
  },
  {  
    {"FIGHTER_B"}, -- B Class Fighter Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   2,    35}, -- 1, 1, 35
    }
  },
  {  
    {"FIGHTER_A"}, -- A Class Fighter Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  2,   3,    65}, -- 1, 2, 65
    }
  },
  {  
    {"FIGHTER_S"}, -- S Class Fighter Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  3,   4,   100}, -- 1, 3, 100
    }
  },
  {  
    {"SCIENCE_C"}, -- C Class Explorer/Science Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   1,    20}, -- 1, 1, 20
    }
  },
  {  
    {"SCIENCE_B"}, -- B Class Explorer/Science Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  1,   2,    35}, -- 1, 1, 35
    }
  },
  {  
    {"SCIENCE_A"}, -- A Class Explorer/Science Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  2,   3,    65}, -- 1, 2, 65
    }
  },
  {  
    {"SCIENCE_S"}, -- S Class Explorer/Science Ship Scrap
    {   -- LootID,      Min, Max, Chance,   Original
      {"SHIP_INV_TOKEN",  3,   4,   100}, -- 1, 3, 100
    }
  },
}
-----------------------------------------------------------
-- Added Loot Changes --
AddLoot =
{
  { -- ListID
    {"CRASHCONT_S"}, -- Crash Freighter Small
    {   -- LootID,      Min, Max, Chance,   Original
      {"FREI_INV_TOKEN",  1,   2,    15}, -- 1, 2, 15
    }
  },
  { -- ListID
    {"CRASHCONT_M"}, -- Crash Freighter Small
    {   -- LootID,      Min, Max, Chance,   Original
      {"FREI_INV_TOKEN",  2,   4,    15}, -- 2, 4, 15
    }
  },
}
-----------------------------------------------------------

-- New Loot Function --
local function NewLoot(id, min, max, chance)
return
[[
          <Property value="GcRewardTableItem.xml">
            <Property name="PercentageChance" value="]]..chance..[[" />
            <Property name="Reward" value="GcRewardSpecificProduct.xml">
              <Property name="Default" value="GcDefaultMissionProductEnum.xml">
                <Property name="DefaultProductType" value="None" />
              </Property>
              <Property name="ID" value="]]..id..[[" />
              <Property name="AmountMin" value="]]..min..[[" />
              <Property name="AmountMax" value="]]..max..[[" />
              <Property name="HideAmountInMessage" value="False" />
              <Property name="ForceSpecialMessage" value="False" />
              <Property name="HideInSeasonRewards" value="False" />
              <Property name="Silent" value="False" />
              <Property name="SeasonRewardListFormat" value="" />
              <Property name="RequiresTech" value="" />
            </Property>
            <Property name="LabelID" value="" />
          </Property>
]]
end
-----------------------------------------------------------

-- File Settings --
FileName    = "More Storage Expansion Modules.pak"
ModAuthor   = "JustRuthless"
LuaAuthor   = "JustRuthless"
ModMaintenance = "Babscoole"
Description = ""
NMS_Version = "3.97"

-- File Sources --
FileSource1 = "METADATA/REALITY/TABLES/REWARDTABLE.MBIN"

NMS_MOD_DEFINITION_CONTAINER = 
{
  ["MOD_FILENAME"]    = FileName,
  ["MOD_AUTHOR"]      = ModAuthor,
  ["LUA_AUTHOR"]      = LuaAuthor,
  ["MOD_MAINTENANCE"] = ModMaintenance,
  ["MOD_DESCRIPTION"] = Description,
  ["NMS_VERSION"]     = NMS_Version,
  ["MODIFICATIONS"]   =                     
  {
    {
      ["MBIN_CHANGE_TABLE"] = 
      { 
        {
          ["MBIN_FILE_SOURCE"]  = FileSource1,
          ["EXML_CHANGE_TABLE"] = 
          {
            -- RewardTable
          }
        },
      }
    },
  }
}

local RewardTable = NMS_MOD_DEFINITION_CONTAINER["MODIFICATIONS"][1]["MBIN_CHANGE_TABLE"][1]["EXML_CHANGE_TABLE"]

for i = 1, #RewardChanges do
  local ListID = RewardChanges[i][1][1]
  local Items  = RewardChanges[i][2]
  
  for j = 1, #Items do
    LootID = Items[j][1]
    Min    = Items[j][2]
    Max    = Items[j][3]
    Chance = Items[j][4]
      
    RewardTable[#RewardTable+1] =
    {
      ["SPECIAL_KEY_WORDS"] = {"Id", ListID, "ID", LootID},
      ["SECTION_UP_SPECIAL"] = 1,
      ["VALUE_CHANGE_TABLE"] = 
      {
        {"AmountMin", Min},
        {"AmountMax", Max},
        {"PercentageChance", Chance},
      },
    }
  end
end

for i = 1, #AddLoot do
  local ListID = AddLoot[i][1][1]
  local Items  = AddLoot[i][2]
  
  for j = 1, #Items do
    LootID = Items[j][1]
    Min    = Items[j][2]
    Max    = Items[j][3]
    Chance = Items[j][4]
      
    RewardTable[#RewardTable+1] =
    {
      ["SPECIAL_KEY_WORDS"] = {"Id", ListID},
      ["PRECEDING_KEY_WORDS"] = {"List", "List"},
      ["ADD"] = NewLoot(LootID, Min, Max, Chance),
    }
  end
end